﻿using EntityFrameworkCoreSample.Models;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.ChangeTracking;
using Microsoft.EntityFrameworkCore.Metadata;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;

namespace EntityFrameworkCoreSample
{
    public class MyClass
    {

        private readonly BloggingContext _context;

        public MyClass(BloggingContext context)
        {
            _context = context;
        }

        public async Task RunSample()
        {
            IEntityType entityType = _context.Model.FindEntityType(typeof(Blog));
            string tableName = entityType.Relational().TableName;
            //Console.WriteLine(tableName);

            IEnumerable<IProperty> properties = entityType.GetProperties();
            //properties.ToList().ForEach(p => Console.WriteLine(p.ClrType.Name));

            //properties.ToList().ForEach(p => Console.WriteLine(p.Relational().ColumnType));

            IEnumerable<INavigation> navigations = entityType.GetNavigations();

            navigations.ToList().ForEach(n => Console.WriteLine(n.Name));

            IProperty property = _context.FindProperty<Blog, string>(b => b.Url);

            string urlColumnName = property.Relational().ColumnName;

            string propertyName = property.Name;

            await Task.CompletedTask;
        }
    }
}
