﻿using Microsoft.EntityFrameworkCore;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using AutoHistorySample.Datas;
using Microsoft.EntityFrameworkCore.ChangeTracking;
using Microsoft.AspNetCore.Http;
using System.Threading;

namespace AutoHistorySample.Datas
{
    public class BloggingContext : DbContext
    {
        private readonly IHttpContextAccessor _httpContextAccessor;

        public BloggingContext(DbContextOptions<BloggingContext> options, IHttpContextAccessor httpContextAccessor) : base(options)
        {
            _httpContextAccessor = httpContextAccessor;
            Database.EnsureCreated();
        }

        protected override void OnModelCreating(ModelBuilder builder)
        {
            builder.Entity<Post>().Property(b => b.Title).HasMaxLength(20);
            builder.Entity<Post>().Property(b => b.Content).HasMaxLength(100);

            builder.Entity<Post>().HasData(new Post { PostId = 1, Title = "First Title", Content = "First Content" });

            builder.EnableAutoHistory(null);

            base.OnModelCreating(builder);
        }

        protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
        {
            base.OnConfiguring(optionsBuilder);
        }


        public DbSet<Post> Posts { get; set; }
    }
}