﻿using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Infrastructure;
using System;

namespace BusinessLogic
{
    public class BloggingContext : DbContext
    {
        #region Constructors
        public BloggingContext(DbContextOptions<BloggingContext> options) : base(options)
        {
        }
        #endregion

        public DbSet<Blog> Blogs { get; set; }

        #region OnConfiguring
        protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
        {
            if (!optionsBuilder.IsConfigured)
            {
                optionsBuilder.UseSqlServer(@"Server=(localdb)\mssqllocaldb;Database=EFProviders.InMemory;Trusted_Connection=True;ConnectRetryCount=0");
            }
        }

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {
            //modelBuilder.Entity<Blog>().ForSqlServerIsMemoryOptimized();
            base.OnModelCreating(modelBuilder);
        }
        #endregion
    }
}
