﻿using Microsoft.EntityFrameworkCore.ChangeTracking;
using System;
using System.Collections.Generic;
using System.Text;

namespace EfCoreSample.Sample2
{
    public static class Sample
    {
        public static void Run()
        {
            BloggingContext context = new BloggingContext();

            context.ChangeTracker.AutoDetectChangesEnabled = false;

            context.ChangeTracker.StateChanged += (s, e) =>
            {
                //Console.WriteLine(e.NewState);
            };

            context.Database.EnsureCreated();

            Blog blog = context.Blogs.Find(1);
            WriteEntry(context.Entry(blog));

            blog.Url = "111.xcode.me";
            WriteEntry(context.Entry(blog));

            var blogObservableCollection = context.Blogs.Local.ToObservableCollection();

            blogObservableCollection.CollectionChanged += (s, e) =>
            {
                Console.WriteLine($"{e.Action},{e.NewItems[0]}");
            };

            context.Blogs.Add(new Blog { Url = "111.xcode.com" });
            context.Blogs.Add(new Blog { Url = "222.xcode.com" });

            //context.ChangeTracker.AcceptAllChanges();

            context.SaveChanges();
            WriteEntry(context.Entry(blog));
        }

        public static void WriteEntry(EntityEntry<Blog> entry)
        {
            string propName = nameof(Blog.Url);

            string database = entry.GetDatabaseValues().GetValue<string>(propName);
            string original = entry.OriginalValues.GetValue<string>(propName);
            string current = entry.CurrentValues.GetValue<string>(propName);

            Console.WriteLine($"state={entry.State},database={database},original={original},current={current}");
        }
    }
}
