﻿using System;
using System.Collections.ObjectModel;
using System.Collections.Specialized;
using System.Threading.Tasks;
using System.Linq;

namespace PropertyChangSample.Sample6
{
    public static class Sample
    {
        public static void Run()
        {
            var collection = new ObservableCollection<long>();

            //collection.CollectionChanged += Collection_CollectionChanged;

            collection.CollectionChanged += (s, e) =>
            {
                Console.WriteLine($"{e.Action},{e.NewItems[0]}");
            };

            while (true)
            {
                collection.Add(DateTime.Now.Ticks);
                Task.Delay(TimeSpan.FromSeconds(1)).Wait();
            }
        }

        private static void Collection_CollectionChanged(object sender, NotifyCollectionChangedEventArgs e)
        {
            Console.WriteLine($"{e.Action},{e.NewItems[0]}");
        }
    }
}
