﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;

namespace EfCoreSample.Sample2
{
    public class Blog : INotifyPropertyChanging, INotifyPropertyChanged
    {
        public event PropertyChangedEventHandler PropertyChanged;

        public event PropertyChangingEventHandler PropertyChanging;

        public int BlogId { get; set; }

        private string url;

        public string Url
        {
            get => url;
            set
            {
                if (value != url)
                {
                    PropertyChanging?.Invoke(this, new PropertyChangingEventArgs(nameof(Url)));
                    this.url = value;
                    PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(nameof(Url)));
                }
            }
        }
    }
}
