﻿using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.ChangeTracking;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace EfCoreSample.Sample1
{
    public static class Sample
    {
        public static void Run()
        {
            BloggingContext context = new BloggingContext();

            context.Database.EnsureCreated();

            context.ChangeTracker.AutoDetectChangesEnabled = false;

            Blog blog = context.Blogs.Find(1);
            WriteEntry(context.Entry(blog));

            //context.Entry(blog).CurrentValues.SetValues(new { Url = "www.xcode.me" });
            context.Entry(blog).Property(nameof(Blog.Url)).CurrentValue = "v.xcode.me"; ;

            WriteEntry(context.Entry(blog));

            context.SaveChanges();
            WriteEntry(context.Entry(blog));

            context.Blogs.Where(b => b.Url.Length > 10).Load();
        }

        public static void WriteEntry(EntityEntry<Blog> entry)
        {
            string propName = nameof(Blog.Url);

            string database = entry.GetDatabaseValues().GetValue<string>(propName);
            string original = entry.OriginalValues.GetValue<string>(propName);
            string current = entry.CurrentValues.GetValue<string>(propName);

            Console.WriteLine($"state={entry.State},database={database},original={original},current={current}");
        }
    }
}
