﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using System.Threading.Tasks;

namespace PropertyChangSample.Sample5
{
    public static class Sample
    {
        public static void Run()
        {
            MyCounter myCounter = new MyCounter();

            myCounter.PropertyChanging += MyCounter_PropertyChanging;
            myCounter.PropertyChanged += MyCounter_PropertyChanged;

            while (true)
            {
                myCounter.CurrentCount++;
                Task.Delay(TimeSpan.FromSeconds(1)).Wait();
            }
        }

        private static void MyCounter_PropertyChanging(object sender, PropertyChangingEventArgs e)
        {
            MyCounter myCounter = sender as MyCounter;
            Console.WriteLine($"{e.PropertyName} before change is {myCounter.CurrentCount}");
        }

        private static void MyCounter_PropertyChanged(object sender, PropertyChangedEventArgs e)
        {
            MyCounter myCounter = sender as MyCounter;
            Console.WriteLine($"{e.PropertyName} after change is {myCounter.CurrentCount}");
        }
    }
}
