﻿using Microsoft.EntityFrameworkCore.ChangeTracking;
using System;
using System.Collections.Generic;
using System.Text;

namespace EfCoreSample.Sample1
{
    public static class Sample
    {
        public static void Run()
        {
            BloggingContext context = new BloggingContext();

            context.Database.EnsureCreated();

            context.ChangeTracker.AutoDetectChangesEnabled = false;

            Blog blog = context.Blogs.Find(1);
            WriteEntry(context.Entry(blog));

            blog.Url = "video.xcode.me";
            context.ChangeTracker.DetectChanges();
            WriteEntry(context.Entry(blog));

            context.SaveChanges();
            WriteEntry(context.Entry(blog));
        }

        public static void WriteEntry(EntityEntry<Blog> entry)
        {
            string propName = nameof(Blog.Url);

            string database = entry.GetDatabaseValues().GetValue<string>(propName);
            string original = entry.OriginalValues.GetValue<string>(propName);
            string current = entry.CurrentValues.GetValue<string>(propName);

            Console.WriteLine($"state={entry.State},database={database},original={original},current={current}");
        }
    }
}
