﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using System.Threading.Tasks;

namespace PropertyChangSample.Sample4
{
    public static class Sample
    {
        public static void Run()
        {
            MyCounter myCounter = new MyCounter();

            myCounter.PropertyChanged += MyCounter_PropertyChanged;

            while (true)
            {
                myCounter.CurrentCount++;
                Task.Delay(TimeSpan.FromSeconds(1)).Wait();
            }
        }

        private static void MyCounter_PropertyChanged(object sender, PropertyChangedEventArgs e)
        {
            MyCounter myCounter = sender as MyCounter;
            Console.WriteLine($"{e.PropertyName} changed to {myCounter.CurrentCount}");
        }
    }
}
