﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;

namespace PropertyChangSample.Sample1
{
    public class MyCounter : INotifyPropertyChanged
    {
        public event PropertyChangedEventHandler PropertyChanged;

        private int currentCount = 0;

        public int CurrentCount
        {
            get => currentCount;
            set
            {
                if (value != currentCount)
                {
                    currentCount = value;
                    PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(nameof(CurrentCount)));
                }
            }
        }
    }
}