﻿using Microsoft.EntityFrameworkCore;
using System;
using System.Collections.Generic;
using System.Data;
using System.Text;
using System.Threading.Tasks;

namespace TransactionSample.IsolationTransaction
{
    public class UnrepeatableReadSample
    {
        /// <summary>
        ///不可重复读（Unrepeatable Read）
        /// </summary>
        public static void Run()
        {
            using (var context = new BankingContext())
            {
                context.Database.EnsureDeleted();
                context.Database.EnsureCreated();

                context.Add(new Account { UserName = "A", Balance = 1000 });
                context.Add(new Account { UserName = "B", Balance = 1000 });

                context.SaveChanges();
            }

            Task.Run(() =>
            {
                using (var context = new BankingContext())
                {
                    using (var transaction = context.Database.BeginTransaction())
                    {
                        try
                        {
                            Task.Delay(TimeSpan.FromSeconds(5)).Wait();

                            var accountA = context.Accounts.Find("A");
                            accountA.Balance -= 500;
                            context.SaveChanges();

                            var accountB = context.Accounts.Find("B");
                            accountB.Balance += 500;
                            context.SaveChanges();

                            transaction.Commit();
                        }
                        catch (Exception e)
                        {
                            Console.WriteLine(e.Message);
                        }
                    }
                }
            });


            Task.Run(() =>
            {
                using (var context = new BankingContext())
                {
                    using (var transaction = context.Database.BeginTransaction(IsolationLevel.RepeatableRead))
                    {
                        try
                        {
                            context.ChangeTracker.QueryTrackingBehavior = QueryTrackingBehavior.NoTracking;

                            var accountA1 = context.Accounts.Find("A");
                            Console.WriteLine($"A balance is {accountA1.Balance}");

                            Task.Delay(TimeSpan.FromSeconds(10)).Wait();

                            var accountA2 = context.Accounts.Find("A");
                            Console.WriteLine($"A balance is {accountA2.Balance}");
                        }
                        catch (Exception)
                        {
                            // TODO: Handle failure
                        }
                    }
                }
            });
        }
    }
}
