﻿using Microsoft.EntityFrameworkCore;
using System;
using System.Collections.Generic;
using System.Data;
using System.Text;
using System.Threading.Tasks;

namespace TransactionSample.IsolationTransaction
{
    public class DirtyReadSample
    {
        /// <summary>
        /// 脏读（Dirty Read）
        /// </summary>
        public static void Run()
        {
            using (var context = new BankingContext())
            {
                context.Database.EnsureDeleted();
                context.Database.EnsureCreated();

                context.Add(new Account { UserName = "A", Balance = 1000 });
                context.Add(new Account { UserName = "B", Balance = 1000 });

                context.SaveChanges();
            }

            Task.Run(() =>
            {
                using (var context = new BankingContext())
                {
                    using (var transaction = context.Database.BeginTransaction())
                    {
                        try
                        {
                            var accountA = context.Accounts.Find("A");
                            accountA.Balance -= 500;
                            context.SaveChanges();

                            Task.Delay(TimeSpan.FromSeconds(10)).Wait();

                            var accountB = context.Accounts.Find("B");
                            accountB.Balance += 500;
                            context.SaveChanges();

                            Console.WriteLine(new Random().Next() / 0);

                            transaction.Commit();
                        }
                        catch (Exception e)
                        {
                            Console.WriteLine(e.Message);
                        }
                    }
                }
            });

            Task.Run(() =>
            {
                using (var context = new BankingContext())
                {
                    using (var transaction = context.Database.BeginTransaction(IsolationLevel.ReadCommitted))
                    {
                        try
                        {
                            Task.Delay(TimeSpan.FromSeconds(5)).Wait();

                            var accountA = context.Accounts.Find("A");
                            var accountB = context.Accounts.Find("B");

                            Console.WriteLine($"A balance is {accountA.Balance}");
                            Console.WriteLine($"B balance is {accountB.Balance}");
                        }
                        catch (Exception)
                        {
                            // TODO: Handle failure
                        }
                    }
                }
            });
        }
    }
}
