﻿using Microsoft.EntityFrameworkCore;
using System;
using System.Collections.Generic;
using System.Data;
using System.Text;
using System.Threading.Tasks;

namespace TransactionSample.DeadlockTransaction
{
    public class Sample
    {
        /// <summary>
        ///  死锁（Deadlock）
        /// </summary>
        public static void Run()
        {
            using (var context = new BankingContext())
            {
                context.Database.EnsureDeleted();
                context.Database.EnsureCreated();

                context.Add(new Account { UserName = "A", Balance = 1000 });
                context.Add(new Account { UserName = "B", Balance = 1000 });

                context.SaveChanges();
            }

            Task.Run(() =>
            {
                using (var context = new BankingContext())
                {
                    using (var transaction = context.Database.BeginTransaction(IsolationLevel.Serializable))
                    {
                        try
                        {
                            var accountA = context.Accounts.Find("A");
                            accountA.Balance -= 500;
                            context.SaveChanges();

                            Task.Delay(TimeSpan.FromSeconds(5)).Wait();

                            var accountB = context.Accounts.Find("B");
                            accountB.Balance += 500;
                            context.SaveChanges();

                            transaction.Commit();
                        }
                        catch (Exception e)
                        {
                            Console.WriteLine(e);
                        }
                    }

                    Console.WriteLine("1 implementation completed");
                }
            });

            Task.Run(() =>
            {
                using (var context = new BankingContext())
                {
                    using (var transaction = context.Database.BeginTransaction(IsolationLevel.Serializable))
                    {
                        try
                        {
                            var accountB = context.Accounts.Find("B");
                            accountB.Balance -= 100;
                            context.SaveChanges();

                            Task.Delay(TimeSpan.FromSeconds(5)).Wait();

                            var accountA = context.Accounts.Find("A");
                            accountA.Balance += 100;
                            context.SaveChanges();

                            transaction.Commit();
                        }
                        catch (Exception e)
                        {
                            Console.WriteLine(e);
                        }
                    }

                    Console.WriteLine("2 implementation completed");
                }
            });
        }
    }
}
