﻿using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Storage;
using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using System.Text;

namespace TransactionSample.SharingTransaction
{
    public class Sample2
    {
        public static void Run()
        {
            var connectionString = @"Server=(localdb)\mssqllocaldb;Database=BankingSample;Trusted_Connection=True";

            using (var context = new BloggingContext2(new SqlConnection(connectionString)))
            {
                context.Database.EnsureDeleted();
                context.Database.EnsureCreated();
            }

            #region Transaction
            var connection = new SqlConnection(connectionString);

            using (var context1 = new BloggingContext2(connection))
            {
                using (var transaction = context1.Database.BeginTransaction())
                {
                    try
                    {
                        context1.Blogs.Add(new Blog { Url = "https://www.xcode.me/dotnet" });
                        context1.SaveChanges();

                        using (var context2 = new BloggingContext2(connection))
                        {
                            context2.Database.UseTransaction(transaction.GetDbTransaction());

                            context2.Database.ExecuteSqlCommand("INSERT INTO [Blogs]([Url]) VALUES({0})", "https://www.xcode.me/efcore");

                            context1.Blogs.Add(new Blog { Url = "https://www.xcode.me/aspnetcore" });
                            context1.SaveChanges();
                        }

                        // Commit transaction if all commands succeed, transaction will auto-rollback
                        // when disposed if either commands fails
                        transaction.Commit();
                    }
                    catch (Exception  e)
                    {
                        // TODO: Handle failure
                        Console.WriteLine(e);
                    }
                }
            }
            #endregion
        }
    }
}
