﻿using Microsoft.EntityFrameworkCore;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace TransactionSample.IsolationTransaction
{
    public class PhantomReadSample
    {
        /// <summary>
        ///幻读（Phantom Read）
        /// </summary>
        public static void Run()
        {
            using (var context = new BankingContext())
            {
                context.Database.EnsureDeleted();
                context.Database.EnsureCreated();

                context.Add(new Account { UserName = "A", Balance = 500 });
                context.Add(new Account { UserName = "B", Balance = 1000 });

                context.SaveChanges();
            }

            Task.Run(() =>
            {
                using (var context = new BankingContext())
                {
                    using (var transaction = context.Database.BeginTransaction())
                    {
                        try
                        {
                            Task.Delay(TimeSpan.FromSeconds(5)).Wait();

                            context.Add(new Account { UserName = "C", Balance = 1000 });
                            context.SaveChanges();

                            context.Add(new Account { UserName = "D", Balance = 1000 });
                            context.SaveChanges();

                            transaction.Commit();
                        }
                        catch (Exception e)
                        {
                            Console.WriteLine(e.Message);
                        }
                    }
                }
            });


            Task.Run(() =>
            {
                using (var context = new BankingContext())
                {
                    using (var transaction = context.Database.BeginTransaction(IsolationLevel.Serializable))
                    {
                        try
                        {
                            context.ChangeTracker.QueryTrackingBehavior = QueryTrackingBehavior.NoTracking;

                            var accountList1 = context.Accounts.Where(a => a.Balance > 500);
                            Console.WriteLine($"Balance of more than 500 accounts have the following:");
                            foreach (var account in accountList1)
                            {
                                Console.WriteLine($"{account.UserName}---{account.Balance}");
                            }

                            Task.Delay(TimeSpan.FromSeconds(10)).Wait();

                            var accountList2 = context.Accounts.Where(a => a.Balance > 500);
                            Console.WriteLine($"Balance of more than 500 accounts have the following:");
                            foreach (var account in accountList1)
                            {
                                Console.WriteLine($"{account.UserName}---{account.Balance}");
                            }
                        }
                        catch (Exception)
                        {
                            // TODO: Handle failure
                        }
                    }
                }
            });
        }
    }
}
