﻿using Microsoft.EntityFrameworkCore;
using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using System.Text;

namespace TransactionSample.ExternalDbTransaction
{
    public class Sample
    {
        public static void Run()
        {
            var connectionString = @"Server=(localdb)\mssqllocaldb;Database=TransactionSample;Trusted_Connection=True;ConnectRetryCount=0";

            using (var context = new BloggingContext(new DbContextOptionsBuilder<BloggingContext>().UseSqlServer(connectionString).Options))
            {
                context.Database.EnsureDeleted();
                context.Database.EnsureCreated();
            }

            #region Transaction
            using (var connection = new SqlConnection(connectionString))
            {
                connection.Open();

                using (var transaction = connection.BeginTransaction())
                {
                    try
                    {
                        // Run raw ADO.NET command in the transaction
                        var command = connection.CreateCommand();
                        command.Transaction = transaction;
                        command.CommandText = "INSERT INTO [Blogs]([Url]) VALUES(@Url)";
                        command.Parameters.Add(new SqlParameter("@Url", "https://www.xcode.me/efcore"));
                        command.ExecuteNonQuery();

                        // Run an EF Core command in the transaction
                        var options = new DbContextOptionsBuilder<BloggingContext>().UseSqlServer(connection).Options;

                        using (var context = new BloggingContext(options))
                        {
                            context.Database.UseTransaction(transaction);
                            context.Blogs.Add(new Blog { Url = "https://www.xcode.me/dotnet" });
                            context.SaveChanges();
                        }

                        // Commit transaction if all commands succeed, transaction will auto-rollback
                        // when disposed if either commands fails
                        transaction.Commit();
                    }
                    catch (Exception e)
                    {
                        Console.WriteLine(e);
                    }
                }
            }
            #endregion
        }
    }
}
