﻿using System;
using System.Collections.Generic;
using System.Text;

namespace TransactionSample.DefaultTransaction
{
    public class Sample
    {
        public static void Run()
        {
            using (var context = new BloggingContext())
            {
                context.Database.EnsureDeleted();
                context.Database.EnsureCreated();
            }

            #region Transaction
            using (var context = new BloggingContext())
            {   
                context.Blogs.Add(new Blog { Url = "https://www.xcode.me/dotnet" });

                context.Blogs.Add(new Blog { Url = "https://www.xcode.me/visualstudio"});

                context.SaveChanges();
            }
            #endregion
        }
    }
}