﻿using Microsoft.EntityFrameworkCore;
using System;
using System.Collections.Generic;
using System.Text;

namespace TransactionSample.ControllingTransaction
{
    public class Sample
    {
        public static void Run()
        {
            using (var context = new BloggingContext())
            {
                context.Database.EnsureDeleted();
                context.Database.EnsureCreated();
            }

            #region Transaction
            using (var context = new BloggingContext())
            {
                using (var transaction = context.Database.BeginTransaction())
                {
                    try
                    {
                        context.Blogs.Add(new Blog { Url = "https://www.xcode.me/dotnet" });
                        context.SaveChanges();

                        context.Blogs.Add(new Blog { Url = "https://www.xcode.me/visualstudio" });
                        context.SaveChanges();

                        context.Database.ExecuteSqlCommand("INSERT INTO [Blogs]([Url]) VALUES({0})", "https://www.xcode.me/efcore");

                        // Commit transaction if all commands succeed, transaction will auto-rollback
                        // when disposed if either commands fails
                        transaction.Commit();
                    }
                    catch (Exception)
                    {
                        // TODO: Handle failure
                    }
                }
            }
            #endregion
        }
    }
}
