﻿using EntityFrameworkCoreSample.Models;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;

namespace EntityFrameworkCoreSample
{
    public static class SeedData
    {
        public async static Task Seed(BloggingContext _context)
        {
            _context.Blogs.Add(
                new Blog
                {
                    Name = "Fish Blog",
                    Url = "https://www.xcode.me/blogs/fish",
                    Posts = new List<Post>
                    {
                        new Post { Title = "Fish care 101"},
                        new Post { Title = "Caring for tropical fish"},
                        new Post { Title = "Types of ornamental fish" }
                    }
                });

            _context.Blogs.Add(
                new Blog
                {
                    Name = "Cats Blog",
                    Url = "https://www.xcode.me/blogs/cats",
                    Posts = new List<Post>
                    {
                        new Post { Title = "Cat care 101" },
                        new Post { Title = "Caring for tropical cats", },
                        new Post { Title = "Types of ornamental cats"}
                    }
                });

            _context.Blogs.Add(
                new Blog
                {
                    Name = "Catfish Blog",
                    Url = "https://www.xcode.me/blogs/catfish",
                    Posts = new List<Post>
                    {
                       new Post { Title = "Catfish care 101",},
                       new Post { Title = "History of the catfish name"}
                    }
                });

            var blog = new Blog
            {
                Name = "zerodo",
                Url = "www.xcode.me",
                Posts = new List<Post>
                {
                    new Post { Title = "Intro to C#" },
                    new Post { Title = "Intro to VB.NET" },
                    new Post { Title = "Intro to F#" }
                }
            };

            await _context.SaveChangesAsync();
        }
    }
}
