﻿using System;
using System.Linq;
using System.Linq.Expressions;
using System.Threading;
using System.Threading.Tasks;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Metadata;

namespace EntityFrameworkCoreSample.Models
{
    public class BloggingContext : DbContext
    {
        public BloggingContext(DbContextOptions<BloggingContext> options) : base(options)
        {
        }

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {
            //modelBuilder.Entity<Blog>().Property(b => b.CreateDate).HasDefaultValue(DateTime.Now);
            modelBuilder.Entity<Blog>().Property(b => b.CreateDate).HasDefaultValueSql("GETDATE()");

            modelBuilder.Entity<Blog>().Property(b => b.UpdateDate).HasDefaultValueSql("GETDATE()");

            modelBuilder.Entity<Blog>().Property(b => b.UpdateDate).ValueGeneratedOnAddOrUpdate();
            modelBuilder.Entity<Blog>().Property(b => b.UpdateDate).Metadata.AfterSaveBehavior = PropertySaveBehavior.Ignore;

            base.OnModelCreating(modelBuilder);
        }

        public virtual DbSet<Blog> Blogs { get; set; }

        public virtual DbSet<Post> Posts { get; set; }
    }
}
