﻿using Microsoft.EntityFrameworkCore;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace MultiTenancySample.Models
{
    public class TenantsContext : DbContext
    {
        public TenantsContext(DbContextOptions<TenantsContext> options) : base(options)
        {
        }

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {
            modelBuilder.Entity<Tenant>(builder =>
            {
                builder.HasKey(t => t.Id);
                builder.Property(t => t.Name).HasMaxLength(100).IsRequired();

                builder.HasData(new Tenant { Id = 11, Name = "Tenant11" });
                builder.HasData(new Tenant { Id = 22, Name = "Tenant22" });
            });

            modelBuilder.Entity<User>(builder =>
            {
                builder.HasKey(t => t.Id);
                builder.Property(t => t.UserName).HasMaxLength(100).IsRequired();
                builder.Property(t => t.Password).HasMaxLength(100).IsRequired();

                builder.HasOne(u=>u.Tenant).WithMany().HasForeignKey(u=>u.TenantId);

                builder.HasData(new User { Id = 1, UserName = "user1", Password = "pwd1", TenantId = 11 });
                builder.HasData(new User { Id = 2, UserName = "user2", Password = "pwd2", TenantId = 22 });
                builder.HasData(new User { Id = 3, UserName = "user3", Password = "pwd3", TenantId = 11 });
            });

            base.OnModelCreating(modelBuilder);
        }

        private DbSet<Tenant> Tenants { get; set; }
    }
}
