﻿using EntityFrameworkCoreSample.Models;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Logging;
using Microsoft.Extensions.Logging.Console;
using System;
using System.IO;

namespace EntityFrameworkCoreSample
{
    class Program
    {
        [Obsolete]
        static void Main(string[] args)
        {
            ServiceCollection serviceCollection = new ServiceCollection();

            var configurationBuilder = new ConfigurationBuilder().SetBasePath(Directory.GetCurrentDirectory()).AddJsonFile("appsettings.json");

            var configuration = configurationBuilder.Build();

            LoggerFactory myLoggerFactory = new LoggerFactory(new[] { new ConsoleLoggerProvider((category, level) => category == DbLoggerCategory.Database.Command.Name && level == LogLevel.Information, true) });

            serviceCollection.AddDbContextPool<BloggingContext>(options => options.UseSqlServer(configuration.GetConnectionString("blogging")).UseLoggerFactory(myLoggerFactory).EnableSensitiveDataLogging());

            var services = serviceCollection.BuildServiceProvider();

            var instance = ActivatorUtilities.CreateInstance<MyClass>(services);

            instance.RunSample();

            Console.WriteLine("Hello World!");

            Console.ReadKey();
        }
    }
}
