﻿using System;
using System.Linq;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Metadata;
using Microsoft.EntityFrameworkCore.Storage.ValueConversion;

namespace EntityFrameworkCoreSample.Models
{
    public class BloggingContext : DbContext
    {
        public BloggingContext(DbContextOptions<BloggingContext> options) : base(options)
        {

        }

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {
            //modelBuilder.Query<BlogPostsCount>().ToView("View_BlogPostCounts").Property(v => v.BlogName).HasColumnName("Name");

            modelBuilder.Query<BlogPostsCount>().ToQuery(() => Blogs.Where(b => b.BlogId >= 2).Select(b => new BlogPostsCount { BlogName = b.Name, PostCount = b.Posts.Count() }));

            base.OnModelCreating(modelBuilder);
        }

        public virtual DbSet<Blog> Blogs { get; set; }

        public virtual DbSet<Post> Posts { get; set; }

        public virtual DbQuery<BlogPostsCount> BlogPostCounts { get; set; }
    }
}
