﻿using EntityFrameworkCoreSample.Models;
using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;
using Microsoft.EntityFrameworkCore;
using NetTopologySuite;
using GeoAPI.Geometries;

namespace EntityFrameworkCoreSample
{
    public class MyClass
    {

        private readonly BloggingContext _context;

        public MyClass(BloggingContext context)
        {
            _context = context;
        }

        public void RunSample()
        {
            var getometryFactory = NtsGeometryServices.Instance.CreateGeometryFactory(4326);

            var currentLocation = getometryFactory.CreatePoint(new Coordinate(-122.121512, 47.6739882));

            //_context.Blogs.Add(new Blog { Url = "www.xcode.me", XmlUrl = "video.xcode.me", Location = currentLocation });

            Blog blog = _context.Blogs.Find(1);

            Console.WriteLine(blog.Location);

            var blogs = _context.Blogs.OrderBy(b => b.Location.Distance(currentLocation));

            var blogs2 = _context.Blogs.Where(b => b.Location.Distance(currentLocation) < 10);

            _context.SaveChanges();
        }
    }
}
