﻿using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Infrastructure;
using System;
using System.Collections.Generic;
using System.Text;

namespace EntityFrameworkCoreSample.Models
{
    public class CustomModelCacheKeyFactory : IModelCacheKeyFactory
    {
        public object Create(DbContext context)
        {
            if (context is BloggingContext bloggingContext)
            {
                return (context.GetType(), bloggingContext.IgnoreXmlUrlProperty);
            }

            return context.GetType();
        }
    }
}
