﻿using System;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Metadata;
using Microsoft.EntityFrameworkCore.Storage.ValueConversion;

namespace EntityFrameworkCoreSample.Models
{
    public class BloggingContext : DbContext
    {
        public bool? IgnoreXmlUrlProperty { get; set; } = false;

        public BloggingContext(DbContextOptions<BloggingContext> options) : base(options)
        {

        }

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {
            if (IgnoreXmlUrlProperty.HasValue)
            {
                if (IgnoreXmlUrlProperty.Value)
                {
                    modelBuilder.Entity<Blog>().Ignore(b=>b.XmlUrl);
                }
            }

            base.OnModelCreating(modelBuilder);
        }

        public virtual DbSet<Blog> Blogs { get; set; }

        public virtual DbSet<Post> Posts { get; set; }
    }
}
