﻿using System;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Metadata;
using Microsoft.EntityFrameworkCore.Storage.ValueConversion;

namespace EntityFrameworkCoreSample.Models
{
    public class BloggingContext : DbContext
    {
        public BloggingContext(DbContextOptions<BloggingContext> options) : base(options)
        {
        }

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {
            //modelBuilder.HasSequence<int>("NumberTest", "dbo").StartsAt(1000).IncrementsBy(3);

            //modelBuilder.Entity<Blog>().Property(b => b.Rating).HasDefaultValueSql("NEXT VALUE FOR dbo.NumberTest");

            modelBuilder.HasSequence<int>("NumberTest2").StartsAt(1000).IncrementsBy(3);

            modelBuilder.ForSqlServerUseSequenceHiLo("NumberTest2");

            modelBuilder.Entity<Category>().Property(c => c.CategoryID).ForSqlServerUseSequenceHiLo("NumberTest3");

            base.OnModelCreating(modelBuilder);
        }

        //public virtual DbSet<Blog> Blogs { get; set; }

        //public virtual DbSet<Post> Posts { get; set; }

        public DbSet<Product> Products { get; set; }
        public DbSet<Category> Categories { get; set; }
    }
}
