﻿using System;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Metadata;
using Microsoft.EntityFrameworkCore.Storage.ValueConversion;

namespace EntityFrameworkCoreSample.Models
{
    public class BloggingContext : DbContext
    {
        public BloggingContext(DbContextOptions<BloggingContext> options) : base(options)
        {
        }

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {
            //modelBuilder.Entity<Blog>().ToTable("Blog2", schema: "abc");

            //modelBuilder.Entity<Blog>().Property(b => b.Author).HasColumnName("AuthorName");

            //modelBuilder.Entity<Blog>().Property(b => b.Url).HasColumnType("varchar(200)");
            //modelBuilder.Entity<Blog>().Property(b => b.Rating).HasColumnType("decimal(5,2)");

            //modelBuilder.Entity<Blog>(eb =>
            //{
            //    eb.Property(b => b.Url).HasColumnType("varchar(200)");
            //    eb.Property(b => b.Rating).HasColumnType("decimal(5, 2)");
            //});

            //modelBuilder.Entity<Blog>().HasKey(b => b.Id).HasName("PrimaryKey_BlogId");

            //modelBuilder.HasDefaultSchema("blogging");

            modelBuilder.Entity<Blog>().Property(b => b.DisplayName).HasComputedColumnSql("[FirstName]+[LastName]");

            modelBuilder.Entity<Blog>().Property(b => b.Rating).HasDefaultValue(3);

            modelBuilder.Entity<Blog>().Property(b => b.CreateDate).HasDefaultValueSql("getdate()");

            base.OnModelCreating(modelBuilder);
        }

        public virtual DbSet<Blog> Blogs { get; set; }

        public virtual DbSet<Post> Posts { get; set; }

    }
}
