﻿using System;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Metadata;
using Microsoft.EntityFrameworkCore.Storage.ValueConversion;

namespace EntityFrameworkCoreSample.Models
{
    public class BloggingContext : DbContext
    {
        public BloggingContext(DbContextOptions<BloggingContext> options) : base(options)
        {
        }

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {
            modelBuilder.Entity<Blog>().HasData(
                new Blog
                {
                    BlogId = 1,
                    Url = "www.xcode.me"
                },
                new Blog
                {
                    BlogId = 2,
                    Url = "video.xcode.me"
                });

            modelBuilder.Entity<Post>().HasData(new Post() { BlogId = 1, PostId = 1, Title = "First post", Content = "Test 11" });

            modelBuilder.Entity<Post>().HasData(new Post() { BlogId = 2, PostId = 2, Title = "First post", Content = "Test 22" });

            modelBuilder.Entity<Post>().OwnsOne(p => p.AuthorName).HasData(new { PostId = 1, FirstName = "zhang", LastName = "san" }, new { PostId = 2, FirstName = "li", LastName = "si" });

            base.OnModelCreating(modelBuilder);
        }

        public virtual DbSet<Blog> Blogs { get; set; }

        public virtual DbSet<Post> Posts { get; set; }

    }
}
