﻿using EntityFrameworkCoreSample.Models;
using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;
using Microsoft.EntityFrameworkCore;

namespace EntityFrameworkCoreSample
{
    public class MyClass
    {

        private readonly BloggingContext _context;

        public MyClass(BloggingContext context)
        {
            _context = context;
        }

        public void RunSample()
        {
            _context.Blogs.Add(new Blog
            {
                Url = "www.xcode.me",
                BlogStuatus = BlogStuatus.Deleted,
                IsActived = true
            });

            _context.Blogs.Add(new Blog
            {
                Url = "video.xcode.me",
                BlogStuatus = BlogStuatus.Draft,
                IsActived = false
            });

            var blog = _context.Blogs.Find(6);

            Console.WriteLine(blog.IsActived);

            _context.SaveChanges();
        }
    }
}
