﻿using System;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Metadata;

namespace EntityFrameworkCoreSample.Models
{
    public class BloggingContext : DbContext
    {
        public BloggingContext(DbContextOptions<BloggingContext> options) : base(options)
        {
        }

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {
            //modelBuilder.Entity<Blog>().Property(b => b.Url).HasField("_validatedUrl").UsePropertyAccessMode(PropertyAccessMode.FieldDuringConstruction);

            modelBuilder.Entity<Blog>().Property<string>("UrlAddress").HasField("_validatedUrl").UsePropertyAccessMode(PropertyAccessMode.Field);

            base.OnModelCreating(modelBuilder);
        }

        public virtual DbSet<Blog> Blogs { get; set; }

        public virtual DbSet<Post> Posts { get; set; }

    }
}
