﻿using System;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Metadata;

namespace EntityFrameworkCoreSample.Models
{
    public class BloggingContext : DbContext
    {
        public BloggingContext(DbContextOptions<BloggingContext> options) : base(options)
        {
        }

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {
            //modelBuilder.Entity<DetailedOrder>().ToTable("Orders");

            //modelBuilder.Entity<Order>().ToTable("Orders").HasOne(o=>o.DetailedOrder).WithOne().HasForeignKey<Order>(o=>o.Id);

            //modelBuilder.Entity<Order>().OwnsOne(typeof(StreetAddress), "ShippingAddress");

            //modelBuilder.Entity<Order>().OwnsOne(p => p.ShippingAddress, sa =>
            //{
            //    sa.Property(p => p.Street).HasColumnName("ShipsToStreet").HasMaxLength(10);
            //    sa.Property(p => p.City).HasColumnName("ShipsToCity");
            //});

            //modelBuilder.Entity<Order>().OwnsOne(p => p.ShippingAddress1);
            //modelBuilder.Entity<Order>().OwnsOne(p => p.ShippingAddress2);

            //modelBuilder.Entity<Order>().OwnsOne(o => o.OrderDetails, od =>
            //{
            //    od.OwnsOne(cd => cd.BillingAddress, cd1 =>
            //    {
            //        cd1.ToTable("BillingAddress");
            //    });
            //    od.OwnsOne(cd => cd.ShippingAddress);
            //    od.ToTable("OrderDetails");
            //});

            modelBuilder.Entity<Order>().OwnsMany(o => o.StreetAddresss, a =>
            {
                a.HasForeignKey("OrderId");
                a.Property<int>("Id");
                a.HasKey("Id", "OrderId");
            });

            base.OnModelCreating(modelBuilder);
        }

        public virtual DbSet<Blog> Blogs { get; set; }

        public virtual DbSet<Post> Posts { get; set; }

        public virtual DbSet<Order> Orders { get; set; }
    }
}
