﻿using System;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Metadata;

namespace EntityFrameworkCoreSample.Models
{
    public class BloggingContext : DbContext
    {
        public BloggingContext(DbContextOptions<BloggingContext> options) : base(options)
        {
        }

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {
            //modelBuilder.Entity<RssBlog>().HasBaseType((Type)null).HasKey(rb => rb.BlogId);
            //modelBuilder.Entity<XmlBlog>().HasBaseType((Type)null);

            //modelBuilder.Entity<Blog>().Property("Discriminator").HasMaxLength(99);

            //modelBuilder.Entity<Blog>().HasDiscriminator<string>("BlogType").HasValue<Blog>("Blog_Base").HasValue<RssBlog>("Rss_Blog").HasValue<XmlBlog>("Xml_Blog");

             modelBuilder.Entity<Blog>().HasDiscriminator<int>("BlogType").HasValue<Blog>(0).HasValue<RssBlog>(1).HasValue<XmlBlog>(2);

            base.OnModelCreating(modelBuilder);
        }

        public virtual DbSet<Blog> Blogs { get; set; }

        public virtual DbSet<RssBlog> RssBlogs { get; set; }

        public virtual DbSet<XmlBlog> XmlBlogs { get; set; }

        public virtual DbSet<Post> Posts { get; set; }
    }
}
