﻿using System;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Metadata;

namespace EntityFrameworkCoreSample.Models
{
    public class BloggingContext : DbContext
    {
        public BloggingContext(DbContextOptions<BloggingContext> options) : base(options)
        {
        }

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {
            //modelBuilder.Entity<Blog>().HasIndex(b => b.Url).IsUnique();

            //modelBuilder.Entity<Person>().HasIndex(p => new { p.FirstName, p.LastName }).HasName("Index_Person_FirstName_LastName");

            //modelBuilder.Entity<Blog>().HasIndex(b => b.Url).HasFilter("[Url] IS NOT NULL");

            //modelBuilder.Entity<Blog>().HasIndex(b => b.Url).IsUnique().HasFilter(null) ;

            modelBuilder.Entity<Post>().HasOne(p => p.Blog).WithMany(b => b.Posts).HasForeignKey(p => p.BlogUrl).HasPrincipalKey(b => b.Url);

            modelBuilder.Entity<Blog>().HasAlternateKey(b => new { b.LicensePlate1, b.LicensePlate2 }).HasName("abc");

            base.OnModelCreating(modelBuilder);
        }

        public virtual DbSet<Blog> Blogs { get; set; }

        public virtual DbSet<Post> Posts { get; set; }
    }
}
