﻿using System;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Metadata;

namespace EntityFrameworkCoreSample.Models
{
    public class BloggingContext : DbContext
    {
        public BloggingContext(DbContextOptions<BloggingContext> options) : base(options)
        {
        }

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {
            //modelBuilder.Entity<Post>().HasOne(p => p.Blog).WithMany(b => b.Posts).HasForeignKey(p => p.BlogUrl).HasPrincipalKey(b => b.Url);

            //modelBuilder.Entity<Post>().HasOne(p => p.Blog).WithMany(b => b.Posts).HasForeignKey(p => new { p.BlogUrl, p.BlogState }).HasPrincipalKey(b => new { b.Url, b.State });

            //modelBuilder.Entity<Post>().HasOne(p => p.Blog).WithMany(b => b.Posts).IsRequired().HasForeignKey("BId");

            //modelBuilder.Entity<Blog>().HasOne(b => b.BlogImage).WithOne(bi => bi.Blog).HasForeignKey<Blog>("BID").IsRequired();

            modelBuilder.Entity<BlogImage>().HasOne(bi => bi.Blog).WithOne(b => b.BlogImage).HasForeignKey<BlogImage>(bi => bi.BID);

            modelBuilder.Entity<PostTag>().HasKey(t => new { t.PostId, t.TagId });

            modelBuilder.Entity<PostTag>().HasOne(pt => pt.Post).WithMany(p => p.PostTags).HasForeignKey(pt => pt.PostId);

            modelBuilder.Entity<PostTag>().HasOne(pt => pt.Tag).WithMany(t => t.PostTags).HasForeignKey(pt => pt.TagId);

            base.OnModelCreating(modelBuilder);
        }

        public virtual DbSet<Blog> Blogs { get; set; }

        public virtual DbSet<Post> Posts { get; set; }
    }
}
