﻿using System;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Metadata;

namespace EntityFrameworkCoreSample.Models
{
    public class BloggingContext : DbContext
    {
        public BloggingContext(DbContextOptions<BloggingContext> options) : base(options)
        {
        }

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {
            //modelBuilder.Entity<Post>().HasOne(p => p.Author).WithMany(u => u.AuthoredPosts).HasForeignKey("AuthorID");

            modelBuilder.Entity<Post>().HasOne(p => p.Author).WithMany(u => u.AuthoredPosts).HasForeignKey(p => p.AuthorID);

            modelBuilder.Entity<Post>().HasOne(p => p.Contributor).WithMany(u => u.ContributedToPosts);

            //modelBuilder.Entity<Post>().HasOne(p => p.Blog).WithMany(b => b.Posts);

            modelBuilder.Entity<Post>().HasOne(p => p.Blog).WithMany();

            modelBuilder.Entity<Blog>().HasKey(b => new { b.BlogId, b.BlogState });

            modelBuilder.Entity<Blog>().HasMany(b => b.Posts).WithOne(p => p.Blog).HasForeignKey(p => new { p.BlogId, p.BlogState });

            //modelBuilder.Entity<Blog>().HasKey("BlogId", "BlogState");

            modelBuilder.Entity<Blog>().HasMany(b => b.Posts).WithOne(p => p.Blog).HasForeignKey("BlogId", "BlogState");

            base.OnModelCreating(modelBuilder);
        }

        public virtual DbSet<Blog> Blogs { get; set; }

        public virtual DbSet<Post> Posts { get; set; }
    }
}
