﻿using EntityFrameworkCoreSample.Models;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using System;
using System.IO;
using System.Linq;

namespace EntityFrameworkCoreSample
{
    class Program
    {
        static void Main(string[] args)
        {
            ServiceCollection serviceCollection = new ServiceCollection();

            var configurationBuilder = new ConfigurationBuilder().SetBasePath(Directory.GetCurrentDirectory()).AddJsonFile("appsettings.json");

            var configuration = configurationBuilder.Build();

            serviceCollection.AddDbContextPool<BloggingContext>(options => options.UseSqlServer(configuration.GetConnectionString("test")));

            var services = serviceCollection.BuildServiceProvider();

            var instance = ActivatorUtilities.CreateInstance<MyClass>(services);

            instance.RunSample();

            TimestampTest();

            Console.WriteLine("Hello World!");

            Console.ReadKey();
        }

        static void ConcurrencyCheckTest()
        {
            var configurationBuilder = new ConfigurationBuilder().SetBasePath(Directory.GetCurrentDirectory()).AddJsonFile("appsettings.json");

            var configuration = configurationBuilder.Build();

            var dbContextOptionsBuilder = new DbContextOptionsBuilder<BloggingContext>();

            dbContextOptionsBuilder.UseSqlServer(configuration.GetConnectionString("test"));

            BloggingContext db1 = new BloggingContext(dbContextOptionsBuilder.Options);
            User user1 = db1.Users.Find(1);

            BloggingContext db2 = new BloggingContext(dbContextOptionsBuilder.Options);
            User user2 = db2.Users.Find(1);

            user1.Memory = user1.Memory - 1;
            db1.SaveChanges();

            try
            {
                user2.Memory = user2.Memory - 1;
                db2.SaveChanges();
            }
            catch (DbUpdateConcurrencyException ex)
            {
                var entityEntry = ex.Entries.Single();

                var original = entityEntry.OriginalValues.ToObject() as User; //数据库原始

                var database = entityEntry.GetDatabaseValues().ToObject() as User; //数据库现在值

                var current = entityEntry.CurrentValues.ToObject() as User; //当前内存值

                entityEntry.Reload();

                current.Memory = current.Memory - 1;

                entityEntry.CurrentValues.SetValues(current);

                db2.SaveChanges();
            }
        }

        static void TimestampTest()
        {
            var configurationBuilder = new ConfigurationBuilder().SetBasePath(Directory.GetCurrentDirectory()).AddJsonFile("appsettings.json");

            var configuration = configurationBuilder.Build();

            var dbContextOptionsBuilder = new DbContextOptionsBuilder<BloggingContext>();

            dbContextOptionsBuilder.UseSqlServer(configuration.GetConnectionString("test"));

            BloggingContext db1 = new BloggingContext(dbContextOptionsBuilder.Options);
            User user1 = db1.Users.Find(1);

            BloggingContext db2 = new BloggingContext(dbContextOptionsBuilder.Options);
            User user2 = db2.Users.Find(1);

            user1.Memory = user1.Memory - 1;
            db1.SaveChanges();

            user2.Memory = user2.Memory - 1;
            db2.SaveChanges();
        }
    }
}
