﻿using System;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Metadata;

namespace EntityFrameworkCoreSample.Models
{
    public class BloggingContext : DbContext
    {
        public BloggingContext(DbContextOptions<BloggingContext> options) : base(options)
        {
        }

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {
            modelBuilder.Entity<Book>();

            //modelBuilder.Entity<Blog>().Property(b => b.BlogId).ValueGeneratedOnAdd();

            modelBuilder.Entity<Blog>().Property(b => b.Url).IsRequired().HasMaxLength(500);

            //modelBuilder.Entity<User>().Property(u => u.Memory).IsConcurrencyToken();

            modelBuilder.Entity<User>().Property(u => u.Timestamp).IsRowVersion();

            base.OnModelCreating(modelBuilder);
        }

        public virtual DbSet<Blog> Blogs { get; set; }

        public virtual DbSet<Post> Posts { get; set; }

        public virtual DbSet<User> Users { get; set; }
    }
}
