﻿using FirstEfCoreSample.Models;
using Microsoft.Data.Sqlite;
using Microsoft.EntityFrameworkCore;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace FirstEfCoreSample.Services
{
    public class BlogService
    {
        public IEnumerable<Blog> GetBlogs()
        {
            var optionsBuilder = new DbContextOptionsBuilder<BloggingContext>();

            optionsBuilder.UseSqlite("");

            using (BloggingContext db=new BloggingContext(optionsBuilder.Options))
            {
               return db.Blogs;
            }
        }

        public IEnumerable<Blog> GetBlogs2()
        {
            //using (BloggingContext db = new BloggingContext())
            //{
            //    return db.Blogs;
            //}

            throw new NotImplementedException();
        }

        public void CreateBlogForSqlLite(Blog blog)
        {
            var connection = new SqliteConnection("DataSource=:memory:");
            connection.Open();

            var options = new DbContextOptionsBuilder<BloggingContext>()
                .UseSqlite(connection)
                .Options;

            using (BloggingContext db = new BloggingContext(options))
            {
                db.Blogs.Add(new Blog { Url="www.xcode.me" });
                db.SaveChanges();
            }
        }

        public void CreateBlogForInMemory(Blog blog)
        {
            var options = new DbContextOptionsBuilder<BloggingContext>()
                .UseInMemoryDatabase("BloggingContext")
                .Options;

            using (BloggingContext db = new BloggingContext(options))
            {
                db.Blogs.Add(new Blog { Url = "www.xcode.me" });
                db.SaveChanges();
            }
        }
    }
}
