﻿using System;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Metadata;

namespace FirstEfCoreSample.Models
{
    public class BloggingContext : DbContext
    {
        public BloggingContext(DbContextOptions<BloggingContext> options) : base(options)
        {
        }

        //protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
        //{
        //    optionsBuilder.UseSqlite("");

        //    base.OnConfiguring(optionsBuilder);
        //}

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {
            modelBuilder.Entity<Blog>().Property(b => b.Remark).IsRequired();

            modelBuilder.Entity<Book>();

            modelBuilder.Ignore<BlogMetadata>();

            modelBuilder.Entity<Blog>().Ignore(b => b.LoadedFromDatabase);

            modelBuilder.Entity<KeyModel>().HasKey(km => km.KeyID);

            modelBuilder.Entity<MultiKeyModel>().HasKey(km => new { km.SchoolID, km.StudentID });


            base.OnModelCreating(modelBuilder);
        }

        public virtual DbSet<Blog> Blogs { get; set; }

        public virtual DbSet<Post> Posts { get; set; }
    }
}
