﻿using System;
using Microsoft.EntityFrameworkCore.Metadata;
using Microsoft.EntityFrameworkCore.Migrations;

namespace FirstEfCoreSample.Migrations
{
    public partial class AddBlogMetadata : Migration
    {
        protected override void Up(MigrationBuilder migrationBuilder)
        {
            migrationBuilder.AddColumn<int>(
                name: "MetadataId",
                table: "Blogs",
                nullable: true);

            migrationBuilder.CreateTable(
                name: "BlogMetadata",
                columns: table => new
                {
                    Id = table.Column<int>(nullable: false)
                        .Annotation("SqlServer:ValueGenerationStrategy", SqlServerValueGenerationStrategy.IdentityColumn),
                    LoadedFromDatabase = table.Column<DateTime>(nullable: false)
                },
                constraints: table =>
                {
                    table.PrimaryKey("PK_BlogMetadata", x => x.Id);
                });

            migrationBuilder.CreateIndex(
                name: "IX_Blogs_MetadataId",
                table: "Blogs",
                column: "MetadataId");

            migrationBuilder.AddForeignKey(
                name: "FK_Blogs_BlogMetadata_MetadataId",
                table: "Blogs",
                column: "MetadataId",
                principalTable: "BlogMetadata",
                principalColumn: "Id",
                onDelete: ReferentialAction.Restrict);
        }

        protected override void Down(MigrationBuilder migrationBuilder)
        {
            migrationBuilder.DropForeignKey(
                name: "FK_Blogs_BlogMetadata_MetadataId",
                table: "Blogs");

            migrationBuilder.DropTable(
                name: "BlogMetadata");

            migrationBuilder.DropIndex(
                name: "IX_Blogs_MetadataId",
                table: "Blogs");

            migrationBuilder.DropColumn(
                name: "MetadataId",
                table: "Blogs");
        }
    }
}
