﻿using System;

namespace ConsoleAppSample
{
    class Program
    {
        static void Main(string[] args)
        {
            using (var db = new BloggingContext())
            {
                db.Blogs.Add(new Blog { Url = "www.xcode.me" });

                var count = db.SaveChanges();

                Console.WriteLine("{0} records saved to database", count);

                Console.WriteLine();

                Console.WriteLine("All blogs in database:");

                foreach (var blog in db.Blogs)
                {
                    Console.WriteLine(" - {0}", blog.Url);
                }
            }

            Console.WriteLine("Hello World!");
            Console.ReadKey();
        }
    }
}